/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.LevelChunk;
import xaero.common.IXaeroMinimap;
import xaero.common.controls.IKeyBindingHelper;
import xaero.common.gui.IScreenBase;
import xaero.common.misc.IObfuscatedReflection;
import xaero.common.platform.Services;
import xaero.hud.minimap.MinimapLogs;

public class Misc {
    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.f_91067_.m_91589_();
        }
        return mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85441_() / (double)mc.m_91268_().m_85443_();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.f_91067_.m_91594_();
        }
        return mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85442_() / (double)mc.m_91268_().m_85444_();
    }

    public static void drawNormalText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.m_91087_().f_91062_.m_271703_(name, x, y, color, shadow, matrices.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawNormalText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.m_91087_().f_91062_.m_272077_(name, x, y, color, shadow, matrices.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.m_91087_().f_91062_.m_271703_(name, x, y, color, shadow, matrices.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.m_91087_().f_91062_.m_272077_(name, x, y, color, shadow, matrices.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.m_91087_().f_91062_.m_92895_(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                MinimapLogs.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static boolean inputMatchesKeyBinding(IXaeroMinimap modMain, InputConstants.Type type, int code, KeyMapping kb, int keyConflictContext) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        return kb != null && code != -1 && keyBindingHelper.getBoundKeyOf(kb).m_84868_() == type && keyBindingHelper.getBoundKeyOf(kb).m_84873_() == code && keyBindingHelper.modifiersAreActive(kb, keyConflictContext);
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(LevelChunk chunk) {
        return chunk.m_7697_().m_45588_();
    }

    public static Class<?> getClassForName(String obfuscatedName, String deobfName) throws ClassNotFoundException {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getClassForName(obfuscatedName, deobfName);
    }

    public static Field getFieldReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge) {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getFieldReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge);
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static <A, B> void setReflectFieldValue(A parentObject, Field field, B value) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(parentObject, value);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
    }

    public static Method getMethodReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge, Class<?> ... parameters) {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getMethodReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge, parameters);
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static boolean hasItem(Player player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.m_150109_().f_35976_, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.m_150109_().f_35975_, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static void setFieldText(EditBox field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(EditBox field, String text, int color) {
        field.m_94202_(color);
        if (field.m_94155_().equals(text)) {
            return;
        }
        field.m_94144_(text);
    }

    public static Component getFixedDisplayName(Entity e) {
        Component baseName = e.m_7755_();
        if (baseName == null) {
            return null;
        }
        return e.m_5647_() == null ? baseName.m_6881_() : e.m_5647_().m_6870_((Component)baseName.m_6881_());
    }

    public static boolean hasEffect(Player player, MobEffect effect) {
        return effect != null && player.m_21023_(effect);
    }

    public static boolean hasEffect(MobEffect effect) {
        return Misc.hasEffect((Player)Minecraft.m_91087_().f_91074_, effect);
    }
}

